package gov.va.med.mhv.admin.service.impl.vastaff;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.mhv.admin.converter.OrgConverter;
import gov.va.med.mhv.admin.dto.OrgDTO;
import gov.va.med.mhv.admin.model.Org;
import gov.va.med.mhv.admin.repository.OrganizationRepository;
import gov.va.med.mhv.admin.service.vastaff.OrganizationService;
import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/")
@Service("organizationService")
public class OrganizationServiceImpl implements OrganizationService {

	@Autowired
	private OrganizationRepository organizationRepository;

	@Autowired
	private OrgConverter orgConverter;

	@Override
	@GET
	@Path("/getOrganizationsByType/{orgType}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<OrgDTO> getOrganizationsByType(@PathParam("orgType") String orgType) throws MHVException {
		List<OrgDTO> orgDTOs = null;
		try {
			List<Org> orgs = organizationRepository.getOrganizationsOfType(orgType);
			if (orgs != null && orgs.size() > 0) {
				orgDTOs = orgConverter.convert(orgs);
			} else {
				throw new MHVException("Error in fetching getOrganizationsByType()");
			}
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return orgDTOs;
	}

	@Override
	@GET
	@Path("/getOrganization/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public OrgDTO getOrganization(@PathParam("id") Long orgId) throws MHVException {
		OrgDTO orgDTO = null;
		try {
			Org org = organizationRepository.getOrganization(orgId);
			if (org != null) {
				orgDTO = orgConverter.convert(org);
			} else {
				throw new MHVException("Org Not Found for the orgId::" + orgId);
			}
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return orgDTO;
	}

}